import { View, Text, TouchableOpacity, Dimensions } from "react-native";
import React from "react";
import CommonStyles from "../CommonStyles/CommonStyles";
import MenuIcon from "../../../assets/svgs/menuIcon.svg";
import dpr from "../CustomStyleAttribute/dpr";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const MenuNavigation = (props) => {
    const toggleDrawerMenu = () => {
        props?.navigationProps?.toggleDrawer();
    };
    return (
        <View style={CommonStyles.container}>
            <View style={CommonStyles.customHeaderContainer}>
                <Text style={CommonStyles.headerName}>
                    {props.routeName?.toUpperCase()}
                </Text>
            </View>
            <TouchableOpacity
                onPress={() => toggleDrawerMenu()}
                style={CommonStyles.customHeaderIcon}
            >
                <CustomSVG svgIcon={MenuIcon} width={dpr(31)} height={dpr(22)} />
            </TouchableOpacity>
        </View>
    );
};

export default MenuNavigation;
